/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.algorithms.MatOfflineIterator;
import cz.insophy.inplan.planning.algorithms.OfflineMergeIterator;
import cz.insophy.inplan.planning.algorithms.WpMatMergeIterator;
import cz.insophy.inplan.planning.mokos.DefaultPositioner;
import cz.insophy.inplan.planning.mokos.MinimalTimeBound;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.OperationGroup;
import cz.insophy.inplan.planning.mokos.Positioner;
import cz.insophy.inplan.planning.mokos.PositioningResult;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.AbstractComparableIterator;
import cz.insophy.inplan.util.HopcroftKarp;
import cz.insophy.inplan.util.SimpleComparableIterator;
import cz.insophy.inplan.util.Tuple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GroupPositioningProcessor
extends Processor {
    private Positioner positioner = new DefaultPositioner();

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        Superplan superplan = this.getScheduler().getSuperplan();
        Plan plan = superplan.getPlan();
        HashSet<Operation> resOps = Sets.newHashSet();
        Set<OperationGroup> groups = Sets.newIdentityHashSet();
        for (Operation op : ops) {
            groups.add(op.getGroup());
            op.clearPlannings();
        }
        for (OperationGroup group : groups) {
            HopcroftKarp<Operation, Workplace> hk = HopcroftKarp.create();
            int successCnt = 0;
            long time = 0L;
            for (Operation op : group) {
                MinimalTimeBound.BoundDefinition boundDef = op.getBound();
                time = boundDef.getTime();
                for (Workplace wp : Iterables.filter(boundDef.getSpecifiers(), Workplace.class)) {
                    hk.addEdge(op, wp);
                }
            }
            int possibleCnt = hk.run();
            if (possibleCnt == group.size()) {
                for (Map.Entry entry : hk.getPairing().entrySet()) {
                    Workplace wp;
                    Operation op = (Operation)entry.getKey();
                    wp = (Workplace)entry.getValue();
                    PositioningResult res = this.positioner.position(op.getGar(), op.getAction(), plan, wp, time);
                    if (res.isOk()) {
                        op.addPlanning(res.getActivityChanges());
                        ++successCnt;
                        continue;
                    }
                    op.updateCompositeBound(this, wp, res.getNextPossibleTime());
                }
                if (successCnt != group.size()) continue;
                resOps.addAll(group.getOperations());
                continue;
            }
            group.updateBound(this, time + 86400000L);
        }
        return Tuple.create(this.getDefaultSuccessor(), resOps);
    }

    protected static Iterator<WorkplaceActivity> createPlanningIterator(GeneralizedActionRequest gar, WorkplaceSchedule wps, long time) {
        WpMatMergeIterator wpIter = wps.forwardIteratorWithBubbles(time, true);
        Set<AbstractComparableIterator<OfflineActivity>> matIters = Sets.newIdentityHashSet();
        if (gar != null) {
            Superplan superplan = gar.getSuperplan();
            StoreSchedule ss = superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
            Bom bom = gar.getAction().getBom();
            for (MaterialQuantity mq : bom) {
                Material m3 = mq.getMaterial();
                if (m3.isConsumed()) continue;
                matIters.add(new MatOfflineIterator(ss, m3, time, mq.getQty()));
            }
        }
        WpMatMergeIterator res = matIters.isEmpty() ? wpIter : new WpMatMergeIterator(new SimpleComparableIterator<WorkplaceActivity>(wpIter), new OfflineMergeIterator(matIters));
        return res;
    }
}

